import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import classNames from "classnames";
import React from "react";
import { Dialogs } from "./components/Dialogs.mjs";
import { FollowingIndicator } from "./components/FollowingIndicator.mjs";
import { ToastViewport, Toasts } from "./components/Toasts.mjs";
import { TldrawUiButton } from "./components/primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "./components/primitives/Button/TldrawUiButtonIcon.mjs";
import { PORTRAIT_BREAKPOINT } from "./constants.mjs";
import {
  TldrawUiContextProvider
} from "./context/TldrawUiContextProvider.mjs";
import { useActions } from "./context/actions.mjs";
import { useBreakpoint } from "./context/breakpoints.mjs";
import { useTldrawUiComponents } from "./context/components.mjs";
import { useNativeClipboardEvents } from "./hooks/useClipboardEvents.mjs";
import { useEditorEvents } from "./hooks/useEditorEvents.mjs";
import { useKeyboardShortcuts } from "./hooks/useKeyboardShortcuts.mjs";
import { useReadonly } from "./hooks/useReadonly.mjs";
import { useTranslation } from "./hooks/useTranslation/useTranslation.mjs";
const TldrawUi = React.memo(function TldrawUi2({
  renderDebugMenuItems,
  children,
  hideUi,
  components,
  ...rest
}) {
  return /* @__PURE__ */ jsx(TldrawUiContextProvider, { ...rest, components, children: /* @__PURE__ */ jsx(TldrawUiInner, { hideUi, renderDebugMenuItems, children }) });
});
const TldrawUiInner = React.memo(function TldrawUiInner2({
  children,
  hideUi,
  ...rest
}) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    children,
    hideUi ? null : /* @__PURE__ */ jsx(TldrawUiContent, { ...rest })
  ] });
});
const TldrawUiContent = React.memo(function TldrawUI() {
  const editor = useEditor();
  const msg = useTranslation();
  const breakpoint = useBreakpoint();
  const isReadonlyMode = useReadonly();
  const isFocusMode = useValue("focus", () => editor.getInstanceState().isFocusMode, [editor]);
  const isDebugMode = useValue("debug", () => editor.getInstanceState().isDebugMode, [editor]);
  const {
    SharePanel,
    TopPanel,
    MenuPanel,
    StylePanel,
    Toolbar,
    HelpMenu,
    NavigationPanel,
    HelperButtons,
    DebugPanel,
    CursorChatBubble
  } = useTldrawUiComponents();
  useKeyboardShortcuts();
  useNativeClipboardEvents();
  useEditorEvents();
  const { "toggle-focus-mode": toggleFocus } = useActions();
  return /* @__PURE__ */ jsxs(
    "div",
    {
      className: classNames("tlui-layout", {
        "tlui-layout__mobile": breakpoint < PORTRAIT_BREAKPOINT.TABLET_SM
      }),
      "data-breakpoint": breakpoint,
      children: [
        isFocusMode ? /* @__PURE__ */ jsx("div", { className: "tlui-layout__top", children: /* @__PURE__ */ jsx(
          TldrawUiButton,
          {
            type: "icon",
            className: "tlui-focus-button",
            title: msg("focus-mode.toggle-focus-mode"),
            onClick: () => toggleFocus.onSelect("menu"),
            children: /* @__PURE__ */ jsx(TldrawUiButtonIcon, { icon: "dot" })
          }
        ) }) : /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsxs("div", { className: "tlui-layout__top", children: [
            /* @__PURE__ */ jsxs("div", { className: "tlui-layout__top__left", children: [
              MenuPanel && /* @__PURE__ */ jsx(MenuPanel, {}),
              HelperButtons && /* @__PURE__ */ jsx(HelperButtons, {})
            ] }),
            /* @__PURE__ */ jsx("div", { className: "tlui-layout__top__center", children: TopPanel && /* @__PURE__ */ jsx(TopPanel, {}) }),
            /* @__PURE__ */ jsxs("div", { className: "tlui-layout__top__right", children: [
              SharePanel && /* @__PURE__ */ jsx(SharePanel, {}),
              StylePanel && breakpoint >= PORTRAIT_BREAKPOINT.TABLET_SM && !isReadonlyMode && /* @__PURE__ */ jsx(StylePanel, {})
            ] })
          ] }),
          /* @__PURE__ */ jsxs("div", { className: "tlui-layout__bottom", children: [
            /* @__PURE__ */ jsxs("div", { className: "tlui-layout__bottom__main", children: [
              NavigationPanel && /* @__PURE__ */ jsx(NavigationPanel, {}),
              Toolbar && /* @__PURE__ */ jsx(Toolbar, {}),
              HelpMenu && /* @__PURE__ */ jsx(HelpMenu, {})
            ] }),
            isDebugMode && DebugPanel && /* @__PURE__ */ jsx(DebugPanel, {})
          ] })
        ] }),
        /* @__PURE__ */ jsx(Toasts, {}),
        /* @__PURE__ */ jsx(Dialogs, {}),
        /* @__PURE__ */ jsx(ToastViewport, {}),
        /* @__PURE__ */ jsx(FollowingIndicator, {}),
        CursorChatBubble && /* @__PURE__ */ jsx(CursorChatBubble, {})
      ]
    }
  );
});
export {
  TldrawUi
};
//# sourceMappingURL=TldrawUi.mjs.map
